﻿#!/bin/bash

# Récupérer le chemin absolu du répertoire courant
SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )"

# Définir les noms des dossiers
SOURCE_DIR="$SCRIPT_DIR/1_DEPOSER_ICI"
OUTPUT_DIR="$SCRIPT_DIR/5_SORTIE"

# Définir le nom du fichier CSV
CSV_FILE="$SCRIPT_DIR/3_CORRESPONDANCES.csv"

# Vérifier si les dossiers de sortie existent, sinon les créer
mkdir -p "$OUTPUT_DIR"

# Lire le fichier CSV ligne par ligne
while IFS=, read -r original_name new_name; do
    # Vérifier si la ligne est vide ou un commentaire
    if [[ -z $original_name || $original_name == "#"* ]]; then
        continue
    fi
    
    # Construire les chemins complets des fichiers d'origine et de destination
    source_file="$SOURCE_DIR/$original_name"
    output_file="$OUTPUT_DIR/$new_name"
    
    # Vérifier si le fichier source existe
    if [[ -f $source_file ]]; then
        # Copier le fichier source avec le nouveau nom dans le dossier de sortie
        cp "$source_file" "$output_file"
        echo "Copied $source_file to $output_file"
    else
        echo "File $source_file does not exist."
    fi
done < "$CSV_FILE"