﻿#!/bin/bash

# Récupérer le chemin absolu du répertoire courant
SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )"

# Définir le nom du fichier CSV
CSV_FILE="$SCRIPT_DIR/3_CORRESPONDANCES.csv"

# Définir le chemin du dossier "A_RENOMMER"
SOURCE_DIR="$SCRIPT_DIR/1_DEPOSER_ICI"

# Parcourir les fichiers du dossier "A_RENOMMER"
for file in "$SOURCE_DIR"/*; do
    # Vérifier si le fichier est un fichier régulier
    if [[ -f $file ]]; then
        # Extraire le nom de fichier sans le chemin
        filename=$(basename "$file")
        
        # Écrire la correspondance dans le fichier CSV
        echo "$filename," >> "$CSV_FILE"
    fi
done

echo "Le fichier CSV avec la première colonne remplie a été créé : $CSV_FILE"